/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.connect;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.creeperhost.minetogether.MineTogether;
import net.creeperhost.minetogether.MineTogetherClient;
import net.creeperhost.minetogether.chat.MineTogetherChat;
import net.creeperhost.minetogether.connect.ConnectHost;
import net.creeperhost.minetogether.connect.RemoteServer;
import net.creeperhost.minetogether.connect.lib.netty.packet.CFriendServers;
import net.creeperhost.minetogether.connect.lib.web.GetConnectServersRequest;
import net.creeperhost.minetogether.connect.netty.NettyClient;
import net.creeperhost.minetogether.lib.chat.profile.Profile;
import net.creeperhost.minetogether.lib.chat.profile.ProfileManager;
import net.creeperhost.minetogether.lib.web.ApiClientResponse;
import net.creeperhost.minetogether.repack.net.covers1624.quack.collection.FastStream;
import net.creeperhost.minetogether.repack.net.covers1624.quack.gson.JsonUtils;
import net.creeperhost.minetogether.session.JWebToken;
import net.creeperhost.minetogether.util.GetClosestDCRequest;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameType;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ConnectHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<RemoteServer, Profile> AVAILABLE_SERVER_MAP = new HashMap<RemoteServer, Profile>();
    private static final ExecutorService SEARCH_EXECUTOR = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("MT Connect Friend Search Executor").build());
    private static final ExecutorService SHARE_EXECUTOR = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("MT Connect Friend Share Executor").build());
    private static long lastSearch = 0L;
    private static CompletableFuture<?> activeSearch = null;
    private static List<CFriendServers.ServerEntry> searchResult = null;
    private static final String FORCED_NODE = System.getProperty("connect.node");
    @Nullable
    private static final String NODE_HOSTS_OVERRIDE = System.getProperty("connect.mesh.hosts");
    private static final Gson GSON = new Gson();
    @Nullable
    private static ConnectHost endpoint;

    public static void init() {
    }

    public static ConnectHost getEndpoint() {
        if (endpoint == null) {
            GetConnectServersRequest.ConnectServer node = ConnectHandler.chooseServer();
            LOGGER.info("Selected MTConnect server: " + node.name);
            endpoint = new ConnectHost(node);
        }
        return endpoint;
    }

    public static ConnectHost getSpecificEndpoint(@Nullable String node) throws IOException {
        if (node == null) {
            return ConnectHandler.getEndpoint();
        }
        List<GetConnectServersRequest.ConnectServer> servers = ConnectHandler.pollServers();
        if (servers == null || servers.isEmpty()) {
            throw new IllegalStateException("No server list returned.");
        }
        GetConnectServersRequest.ConnectServer server = FastStream.of(servers).filter(e -> e.name.equals(node)).firstOrDefault();
        if (server == null) {
            throw new IllegalStateException("Did not find node with id: " + node);
        }
        return new ConnectHost(server);
    }

    private static GetConnectServersRequest.ConnectServer chooseServer() {
        if (Boolean.getBoolean("mt.develop.connect")) {
            return GetConnectServersRequest.ConnectServer.getLocalHost();
        }
        try {
            List<GetConnectServersRequest.ConnectServer> servers = ConnectHandler.pollServers();
            if (servers == null || servers.isEmpty()) {
                LOGGER.warn("No MTConnect nodes found.. :(");
                throw new NotImplementedException();
            }
            if (FORCED_NODE != null) {
                return FastStream.of(servers).filter(e -> e.name.equals(FORCED_NODE)).first();
            }
            GetConnectServersRequest.ConnectServer first = servers.get(0);
            ApiClientResponse<GetClosestDCRequest.Response> closestDCResponse = MineTogether.API.execute(new GetClosestDCRequest());
            if (!closestDCResponse.hasBody()) {
                LOGGER.error("Failed to get Closest DC locations. Using first server: {}", (Object)first.name);
                return first;
            }
            for (GetClosestDCRequest.DataCenter dc : closestDCResponse.apiResponse().getDataCenters()) {
                for (GetConnectServersRequest.ConnectServer server : servers) {
                    if (!server.location.equals(dc.getName())) continue;
                    LOGGER.info("Selected server {}. Closest DC was {}.", (Object)server.name, (Object)dc.getName());
                    return server;
                }
            }
            LOGGER.info("Could not select a server. Using first server: {}", (Object)first.name);
            return first;
        }
        catch (IOException ex) {
            throw new NotImplementedException("TODO, Implement exception handling for this:", (Throwable)ex);
        }
    }

    @Nullable
    private static List<GetConnectServersRequest.ConnectServer> pollServers() throws IOException {
        if (NODE_HOSTS_OVERRIDE != null) {
            return (List)JsonUtils.parse(GSON, Path.of(NODE_HOSTS_OVERRIDE, new String[0]), GetConnectServersRequest.LIST_SERVERS);
        }
        ApiClientResponse<List<GetConnectServersRequest.ConnectServer>> apiResp = MineTogether.API.execute(new GetConnectServersRequest());
        if (apiResp.statusCode() != 200) {
            LOGGER.error("Failed to query node list. Got: {}", (Object)apiResp.statusCode());
            return null;
        }
        return apiResp.apiResponse();
    }

    public static boolean isEnabled() {
        return true;
    }

    public static void publishToFriends(GameType gameType, boolean cheats) {
        Minecraft mc = Minecraft.m_91087_();
        IntegratedServer server = mc.m_91092_();
        if (server == null) {
            return;
        }
        mc.m_193588_();
        server.f_120017_ = 0;
        server.f_174966_ = gameType;
        server.m_6846_().m_11284_(cheats);
        mc.f_91074_.m_108648_(server.m_129944_(mc.f_91074_.m_36316_()));
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            server.m_129892_().m_82095_(player);
        }
        CompletableFuture.runAsync(() -> {
            try {
                JWebToken token = (JWebToken)MineTogetherClient.getSession().get().orThrow();
                NettyClient.publishServer(server, ConnectHandler.getEndpoint(), token);
            }
            catch (Exception e) {
                Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)new TextComponent("minetogether.connect.open.failed"));
                LOGGER.error("Failed to open to friends", (Throwable)e);
                ConnectHandler.unPublish();
            }
        }, SHARE_EXECUTOR);
    }

    public static void unPublish() {
        Minecraft mc = Minecraft.m_91087_();
        IntegratedServer server = mc.m_91092_();
        if (server == null) {
            return;
        }
        server.f_120017_ = -1;
        server.f_174966_ = null;
    }

    public static void updateFriendsSearch() {
        if (activeSearch != null) {
            if (!activeSearch.isDone()) {
                return;
            }
            activeSearch = null;
            if (searchResult != null) {
                ProfileManager profileManager = MineTogetherChat.CHAT_STATE.profileManager;
                HashSet<RemoteServer> keep = new HashSet<RemoteServer>();
                for (CFriendServers.ServerEntry entry2 : searchResult) {
                    RemoteServer server = new RemoteServer(entry2.friend, entry2.serverToken, entry2.node);
                    keep.add(server);
                    if (AVAILABLE_SERVER_MAP.containsKey(server)) continue;
                    Profile profile = profileManager.lookupProfile(entry2.friend);
                    AVAILABLE_SERVER_MAP.put(server, profile);
                }
                AVAILABLE_SERVER_MAP.entrySet().removeIf(entry -> !keep.contains(entry.getKey()));
                searchResult = null;
            }
            return;
        }
        if (System.currentTimeMillis() - lastSearch < 5000L) {
            return;
        }
        lastSearch = System.currentTimeMillis();
        activeSearch = CompletableFuture.runAsync(() -> {
            searchResult = null;
            try {
                JWebToken token = (JWebToken)MineTogetherClient.getSession().get().orThrow();
                searchResult = NettyClient.getFriendServers((ConnectHost)ConnectHandler.getEndpoint(), (JWebToken)token).servers;
            }
            catch (Throwable e) {
                LOGGER.error("An error occurred while searching for friend servers.", e);
            }
        }, SEARCH_EXECUTOR);
    }

    public static Collection<RemoteServer> getRemoteServers() {
        return AVAILABLE_SERVER_MAP.keySet();
    }

    public static Profile getServerProfile(RemoteServer server) {
        return AVAILABLE_SERVER_MAP.get(server);
    }

    public static void clearAndReset() {
        if (activeSearch != null) {
            activeSearch.cancel(true);
            activeSearch = null;
            searchResult = null;
        }
        AVAILABLE_SERVER_MAP.clear();
        lastSearch = 0L;
    }
}

